 ; Ŀ
 ;   Vvl - apply wipeouts to specified text strings.                       
 ;   Also does some search and replace nearby text entities.               
 ;   Copyright 2004, 2005, 2007 - 2010 by Rocket Software Ltd.             
 ;   Why is there no processed meat made from fish?                        
 ; 

 ; Ŀ
 ;   Cedet - find and replace to the left of a specified text string.      
 ; 
 (DEFUN CEDET (/ flist b a)
 ; Ŀ
 ;   Call Sedet to fix the text to the left of the one containing the      
 ;   string in question.  (There should be only one penis.)                
 ; 
  (setq flist '("PIPE GUIDE" "PIPE SHOE" "PIPE ANCHOR" "PIPE CLAMP"))
  (setq b "SEE DETAIL")
  (foreach a flist (sedet a b))
 (princ))
 ; Ŀ
 ;   Cedet end.                                                            
 ; 

 ; Ŀ
 ;   Echo: draw some radar arcs.                                           
 ;   Arguments: Pa, the arc centre.                                        
 ;   Calls Irc, returns nothing.                                           
 ; 
 (DEFUN ECHO (pa / inca radd)
  (setq radd 2)
  (while (<= radd 20)
         (irc pa radd 0.25 pi 12 1)
;         (command "delay" 7)
         (setq radd (+ radd 1)))
 (princ))
 ; Ŀ
 ;   Echo end   end         end.                                           
 ; 

 ; Ŀ
 ;   Gnampo: see if a group name has been used.                            
 ;   Arguments: Gnam, the name to check.                                   
 ;   Calls nothing.                                                        
 ;   Returns T if it has been used, else nil.                              
 ; 
 (DEFUN GNAMPO (gnam / grdict)
 ; Ŀ
 ;   Grdict is the group dictionary - a list of all groups in the drawing  
 ;   and names: (various_stuff (3 . "Group_name") (350 . <Ename>)...)      
 ;   The last two sublists are repeated for each group.                    
 ; 
  (setq grdict (dictsearch (namedobjdict) "acad_group"))
 (if (member (cons 3 gnam) grdict) t nil))
 ; Ŀ
 ;   Gnampo end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Irc - grdraw arc maker.                                    
 ;   Arguments: Pa, the arc centre.                                        
 ;              Radd, the radius.                                          
 ;              Inca, the included angle in radians.                       
 ;              Dira, the midline direction in radians.                    
 ;              Reps, the number of segments.                              
 ;              Colo, the grcolour.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN IRC (pa radd inca dira reps colo / skip angg incr pa1 pa2)
  (setq stangl (- dira (/ inca 2)))
  (setq end1 (polar pa stangl radd))
  (setq incr (/ inca reps))
  (while (< 0 reps)
         (setq reps (1- reps))
         (setq stangl (+ stangl incr))
         (setq end2 (polar pa stangl radd))
         (grdraw end1 end2 colo)
         (setq end1 end2))
 (princ))
 ; Ŀ
 ;   Irc end.                                                              
 ; 

 ; Ŀ
 ;   Mag - make a randomly named group.                                    
 ;   Argument: Ss, a selection set of stuff to group.                      
 ;   Returns a group name.                                                 
 ; 
 (DEFUN MAG (ss / namm)
 ; Ŀ
 ;   Concoct a group name.                                                 
 ; 
  (setq lup (getvar "luprec"))                     ; don't make this local
  (setvar "luprec" 8)
  (while (or (null namm) (gnampo namm))
         (setq namm (rtos (getvar "date")))        ; get the exact time
         (setq namm (strcat "G" (substr namm 9))))
  (setvar "luprec" lup)
 ; Ŀ
 ;   Make the group.                                                       
 ; 
;  (command ".group" "" namm "" ss "")
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
 namm)
 ; Ŀ
 ;   Mag end.                                                              
 ; 

 ; Ŀ
 ;   Noul - erase any lwpline underlines near a text entity.               
 ;   Arguments: Enam, a text entity ename.                                 
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN NOUL (enam / entt tblst cutdis rota cc dd bheigt bwidth llangg lldist
                                                ll ul lr ur outdis lll uur ss)
 ; Ŀ
 ;   Get the entity data list.                                             
 ; 
  (setq entt (entget enam))
  (setq tblst (textbox entt))
  (setq cutdis (* 0.25 (cdr (assoc 40 entt))))
 ; Ŀ
 ;   Get the entity corner points.                                         
 ; 
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Make the search area corner points.                                   
 ; 
  (setq outdis (* (sqrt 2) cutdis bheigt))
  (setq lll (polar ll (+ rota (* pi 1.25)) outdis))
  (setq uur (polar ur (+ rota (* pi 0.25)) outdis))
 ; Ŀ
 ;   Find and erase any underlying underline line.                         
 ; 
  (setq ss (ssget "W" lll uur (list (cons 0 "lwpolyline"))))
  (if (and ss (= (sslength ss) 1))
      (command ".erase" ss ""))
 (princ))
 ; Ŀ
 ;   Noul end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Sedet - replace text to the left of a one with a string.   
 ;   Arguments: Fstr, a string to find.                                    
 ;              Rstr, a string to put into the text entity to the left.    
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SEDET (fstr rstr / ss enam entt pa txht pb pa0 pb0)
 ; Ŀ
 ;   Get the text entity in question.  (There should be only one.)         
 ; 
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 (strcat fstr "*")))))
      (progn
           (setq enam (ssname ss 0))
           (setq entt (entget enam))
           (setq pa (cdr (assoc 10 entt)))
           (echo pa)
           (setq txht (cdr (assoc 40 entt)))
           (setq pb (polar pa (/ pi 2) txht))
           (setq pa0 (polar pa pi 5))
           (setq pb0 (polar pb pi 20))
           (setq ss (ssget "c" pa0 pb0 (list (cons 0 "text"))))
;          (grdraw pa0 pb0 1)
           (setq entt (entget (ssname ss 0)))
           (entmod (subst (cons 1 rstr) (assoc 1 entt) entt))))
 (princ))
 ; Ŀ
 ;   Subroutine Sedet end.                                                 
 ; 

 ; Ŀ
 ;   Soldie - wipe out an area slightly larger than a text entity.         
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Cutdis, the wipeout clearance distance.                    
 ; 
 (DEFUN SOLDIE (enam cutdis / entt tblst rota cc dd bheigt bwidth llangg ss
                              lldist ll ul lr ur outdis lll uul llr uur enamwp)
 ; Ŀ
 ;   Get the entity data list.                                             
 ; 
  (setq entt (entget enam))
  (setq tblst (textbox entt))
 ; Ŀ
 ;   Get the entity corner points.                                         
 ; 
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Make the wipeout corner points.                                       
 ; 
  (setq outdis (* (sqrt 2) cutdis bheigt))
  (setq lll (polar ll (+ rota (* pi 1.25)) outdis))
  (setq uul (polar ul (+ rota (* pi 0.75)) outdis))
  (setq llr (polar lr (+ rota (* pi 1.75)) outdis))
  (setq uur (polar ur (+ rota (* pi 0.25)) outdis))
 ; Ŀ
 ;   Draw a wipeout.                                                       
 ;   Calling Wipeout as a command works in 2005 but only intermittently    
 ;   in 2002, presumably because the lisp routine has been replaced        
 ;   with an internal command.                                             
 ; 
  (if (> (read (substr (getvar "acadver") 1 2)) 14)
      (command ".wipeout" lll uul uur llr "")
      (progn
           (c:wipeout)
           (command lll uul uur llr "")))
  (setq enamwp (entlast))
 ; Ŀ
 ;   Bring the text entity to the front.                                   
 ; 
  (command "draworder" enam "" "front")
 ; Ŀ
 ;   Group it.                                                             
 ; 
  (setq ss (ssadd enam))
  (ssadd enamwp ss)
  (mag ss)
 (princ))
 ; Ŀ
 ;   Soldie end.                                                           
 ; 

 ; Ŀ
 ;   Vvl.                                                                  
 ; 
 (DEFUN C:VVL (/ *error* osm snapp clayer ss enam)
  (setvar "cmdecho" 1)
  (command "undo" "be")
 ; Ŀ
 ;   Save a few settings.                                                  
 ; 
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq clayer (getvar "clayer"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osm)
   (setvar "snapmode" snapp)
   (setvar "clayer" clayer)
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get the text entity in question.  (There should be only one.)         
 ;   Call Noul to kill the underline lwpolyline.                           
 ; 
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "GASKETS"))))
      (noul (ssname ss 0)))
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "PIPE"))))
      (noul (ssname ss 0)))
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "FLANGES"))))
      (noul (ssname ss 0)))
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "FITTINGS"))))
      (noul (ssname ss 0)))
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "BOLTS"))))
      (noul (ssname ss 0)))
 ; Ŀ
 ;   Get the text entity in question.  (There should be only one.)         
 ;   Call Noul to kill the underline lwpolyline, and Soldie to make the    
 ;   wipeout and remove underline lines.                                   
 ; 
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "SUPPORTS"))))
      (progn
           (setq enam (ssname ss 0))
           (noul enam)
           (setvar "clayer" (cdr (assoc 8 (setq entt (entget enam)))))
           (soldie enam (* 0.275 (cdr (assoc 40 entt))))))
  (if (setq ss (ssget "x" (list (cons 0 "text") (cons 1 "INSTRUMENTS"))))
      (progn
           (setq enam (ssname ss 0))
           (noul enam)
           (setvar "clayer" (cdr (assoc 8 (setq entt (entget enam)))))
           (soldie enam (* 0.275 (cdr (assoc 40 entt))))))
  (if (setq ss (ssget "x" (list (cons 0 "text")
                                (cons 1 "VALVES / IN-LINE ITEMS"))))
      (progn
           (setq enam (ssname ss 0))
           (noul enam)
           (setvar "clayer" (cdr (assoc 8 (setq entt (entget enam)))))
           (soldie enam (* 0.12 (cdr (assoc 40 entt))))))
 ; Ŀ
 ;   Call Cedet to seach and nearby replace.  (New type of thing.)         
 ; 
  (cedet)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (command "wipeout" "f" "off")
  (*error* ())
 (princ))